function [f1,f2,d1,d2]=Combination_FM(REQ_D,delta)

% This function finds both nearest anticlockwise & clockwise f1,f2 forces (among the five forces)  
% respectively with thier different angle d1 & d2 from required direction.
% Any force is different than required direction by 86 degree (1.5 rad) is marked as NaN.

angle=1.5; % allowable different angle from required direction (in radians). 
d=wrapToPi(REQ_D-delta); % different matrix between required direction and five forces.
zero=[];Pos=[];Neg=[];Exact_dir=0;% intilialize temporary matrices

% sort negative (clockwise) & positive (anticlockwise) matrices
for i=1:5 
    if d(i) > 0
        Pos=[Pos; d(i)];
    end
        if d(i) < 0
            Neg=[Neg; d(i)];
        end
            if d(i) == 0
                zero=[zero i d(i)];
                disp(['only one f1=', num2str(i),]);f1=i;Exact_dir=1;
            end        
end
if Exact_dir==1 % one of the measured directions is exactly equel to the required direction
     % so apply this freq only and escape the combination method.
   f1=i;d1=delta(i);f2=0;d2=9;
else % find both nearest anticlockwise & clockwise f1,f2 forces 
          

    POS=min(Pos);NEG=min(abs(Neg));
    if isempty(POS)
       f1=0; d1=REQ_D+3.14;
    elseif POS(1)< angle
        for i=1:5 % positive (anticlockwise) force f1 loop
            if POS(1)==d(i)
                f1=i;d1=delta(i);
            end
        end
    else 
        f1=0;d1=REQ_D+3.14;
    end 
    if isempty(NEG)
       f2=0;d2=REQ_D+3.14;
    elseif NEG < angle
        for i=1:5 % negative (clockwise)force f2 loop
            if NEG*(-1)==d(i)
               f2=i;d2=abs(delta(i));
            end
        end
    else 
        f2=0;d2=REQ_D+3.14;
    end

end

